/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides classes and interfaces for dealing with {@code javax.swing.JTable}.
 * {@code JTable} is Swing's grid or tabular view for constructing user
 * interfaces for tabular data structures inside an application. Use this
 * package if you want control over how tables are constructed, updated, and
 * rendered, as well as how data associated with the tables are viewed and
 * managed.
 * <p>
 * <strong>Note:</strong>
 * Most of the Swing API is <em>not</em> thread safe. For details, see
 * <a
 * href="https://docs.oracle.com/javase/tutorial/uiswing/concurrency/index.html"
 * target="_top">Concurrency in Swing</a>,
 * a section in
 * <em><a href="https://docs.oracle.com/javase/tutorial/"
 * target="_top">The Java Tutorial</a></em>.
 *
 * <h2>Related Documentation</h2>
 * For overviews, tutorials, examples, guides, and tool documentation,
 * please see:
 * <ul>
 *     <li><a href="https://docs.oracle.com/javase/tutorial/uiswing/components/table.html"
 *     target="_top">How to Use Tables</a>,
 *     a section in <em>The Java Tutorial</em></li>
 * </ul>
 *
 * @since 1.2
 * @serial exclude
 */
package javax.swing.table;
